#ifndef __CMidiVizEditor__
#define __CMidiVizEditor__

#include <ECore.h>
#include <EMusic.h>
#include <EGUI.h>
#include <EVST.h>

/**
 * @namespace Exponent
 * @brief Main Exponent namespace
 */
namespace Exponent
{
	/**
	 * @namespace MidiViz
	 * @brief MidiViz namespace
	 */
	namespace MidiViz
	{
		/**
		 * @class CMidiVizEditor CMidiVizEditor.hpp
		 * @brief Midi Viz editor vst class
		 *
		 * @date 28/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CMidiVizEditor.hpp,v 1.7 2007/02/11 02:20:17 paul Exp $
		 */
		class CMidiVizEditor : public CVstWindow
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param theEffect The audio effect
			 * @param windowArea The size of the window
			 * @param attributes The window attributes
			 */
			CMidiVizEditor(AudioEffect *theEffect, const CRect &windowArea, CWindowAttributes *attributes);

			/**
			 * Destruction
			 */
			virtual ~CMidiVizEditor();

//	===========================================================================

			/**
			 * Handle and action event
			 * @param event The event to handle
			 */
			virtual void handleActionEvent(const CActionEvent &event);

			/**
			 * Add a midi event
			 * @param event The midi event to store
			 */
			void addEvent(const CMidiEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * @enum EControlIds
			 * @brief Internal control identifiers 
			 */
			enum EControlIds
			{
				e_viewCombo = 1000,																					/**< View combo identifier */
				e_channelEdit,																						/**< Channel editor */
			};

//	===========================================================================

			const static long CMIDIVIZ_EDITOR_NUM_ROWS     = 18;													/**< Total number of rows */
			const static long CMIDIVIZ_EDITOR_NUM_COLS     = 4;														/**< Total number of columns */
			const static long CMIDIVIZ_EDITOR_NUM_CONTROLS = CMIDIVIZ_EDITOR_NUM_ROWS * CMIDIVIZ_EDITOR_NUM_COLS;	/**< Total number of controls */

//	===========================================================================

			CTextLabel *m_labels[CMIDIVIZ_EDITOR_NUM_CONTROLS];														/**< The midi display labels */
			CLatchingButton *m_midiAsNotesButton;																	/**< Midi shown as notes */
			CLatchingButton *m_streamOutputButton;																	/**< Midi streams to disk */
			CMomentaryButton *m_clearOutputButton;																	/**< Clear the output */
			CMenu *m_viewMenu;																						/**< Menu to select what is viewed */
			CComboBox *m_viewCombo;																					/**< The view combo box */
			CTextEdit *m_channelEdit;																				/**< Midi channel editor */

		};
	}
}
#endif	// End of CGFluxEditor